uniform vec2 center; 
uniform vec2 resolution;
uniform float time;
uniform vec2 mouse; 
uniform float pulse1;
uniform float pulse2;
uniform float pulse3; 



float intensity = 1.0;
float radius = 0.05;



float triangleDist(vec2 p){ 
    const float k = sqrt(3.0);
    p.x = abs(p.x) - 1.0;
    p.y = p.y + 1.0/k;
    if( p.x+k*p.y>0.0 ) p=vec2(p.x-k*p.y,-k*p.x-p.y)/2.0;
    p.x -= clamp( p.x, -2.0, 0.0 );
    return -length(p)*sign(p.y);
}

float boxDist(vec2 p){
    vec2 d = abs(p)-1.0;
    return length(max(d,vec2(0))) + min(max(d.x,d.y),0.0);
}

float circleDist( vec2 p){
  return length(p) - 1.0;
}


float getGlow(float dist, float radius, float intensity){
    return pow(radius/dist, intensity);
}

void main(){
    
	vec2 uv = gl_FragCoord/resolution.xy;
    float widthHeightRatio = resolution.x/resolution.y;
    vec2 centre;
    vec2 pos;
	
    float t = time * 0.05;
    
    float dist;
    float glow;
    vec3 col = vec3(0);
    
    
    float scale = 500.0;
    
    float layers = 15.0;
    
    float depth;
    vec2 bend;
    
    vec3 purple = vec3(0.611, 0.129, 0.909);
    vec3 green = vec3(0.133, 0.62, 0.698);
    
    float angle;
    float rotationAngle;
    mat2 rotation;
    
    
    float d = 2.5*(sin(t) + sin(3.0*t));

    
    vec2 anchor = vec2(0.5 + cos(d), 0.5 + sin(d));
    
    
    pos = anchor - uv;
    pos.y /= widthHeightRatio;
    dist = length(pos);
    glow = getGlow(dist, 0.25, 3.5);
    col += glow * vec3(0.6,0.4,1.0);
    
	for(float i = 0.0; i < layers; i++){
        
        
        depth = fract(i/layers + t);

        
        centre = vec2(0.5 + 0.2 * sin(t), 0.5 + 0.2 * cos(t));
        
        
        bend = mix(anchor, centre, depth);
     	
        pos = bend - uv;
    	pos.y /= widthHeightRatio;

        
       	rotationAngle = 3.14 * sin(depth + fract(t) * 6.28) + i;
        rotation = mat2(cos(rotationAngle), -sin(rotationAngle), 
                        sin(rotationAngle),  cos(rotationAngle));
        
        pos *= rotation;
        
        
    	pos *= mix(scale, 0.0, depth);
    	
        float m = mod(i, 3.0);
        if(m == 0.0){
        	dist = abs(boxDist(pos));
        }else if(m == 1.0){
        	dist = abs(triangleDist(pos));
        }else{
        	dist = abs(circleDist(pos));
        }
       
        
    	glow = getGlow(dist, radius+(1.0-depth)*2.0, intensity + depth);
        
        
        angle = (atan(pos.y, pos.x)+3.14)/6.28;
        
		angle = abs((2.0*fract(angle + i/layers)) - 1.0);
        
        
    	
        
        
     	col += glow * mix(green, purple, angle);
	}
    
    
    col = 1.0 - exp(-col);
    
    
    col = pow(col, vec3(0.4545));
    
    
    gl_FragColor = vec4(col,1.0);
}